﻿var questionnaires = {
    context: $(".v-questionnaires"),
    datatable: null,
    treeview: null,
    initializeDataTable: function (folder) {
        this.datatable = $(".h-questionnairesTable", this.context).a4datatable({
            ajaxAction: a4.getAction("GetQuestionnaires", "Home", "Project"),
            ajaxParams: { "folderId": folder ? folder.Id : 0 },
            advancedFilter: true,
            height: "full",
            stateKey: "Questionnaires",
            columns: [
                { "Title": resources.Id, "Data": "Id" },
                { "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Title": resources.Folder, "Data": "FolderName" },
                { "Title": resources.State, "Data": "StateEnum", "Name": "State", "Type": "enum", "EnumType": "QuestionnaireStateType" },
                { "Title": resources.Filename, "Data": "QUEName" },
                { "Title": resources.Locked, "Data": "IsLocked", "Type": "boolean", "ShowIcon": true },
                { "Title": resources.LastAccessed, "Data": "LastAccessed", "Type": "date" }
            ],
            allowRowSelection: true,
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return voxco.security.has('DELETE', data.Permissions); } }
            ],
            contextMenuItems: [
                { "Action": "rename", "Label": resources.Rename, "DisplayCondition": function (data) { return voxco.security.has('MODIFY', data.Permissions); } },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return voxco.security.has('DELETE', data.Permissions); } },
                { "Divider": true },
                { "Action": "update", "Label": resources.Update, "DisplayCondition": function (data) { return voxco.security.has('PUBLISH', data.Permissions); } },
                { "Action": "download", "Label": resources.Download, "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions); } },
                { "Action": "includeFiles", "Label": resources.IncludeFiles },
                { "Divider": true },
                { "Action": "lock", "Label": resources.Lock, "DisplayCondition": function (data) { return voxco.security.has('MODIFY', data.Permissions); } },
                { "Action": "unlock", "Label": resources.Unlock, "DisplayCondition": function (data) { return voxco.security.has('MODIFY', data.Permissions); } },
                { "Divider": true },
                { "Action": "messages", "Label": resources.TranslateMessages, "DisplayCondition": function (data) { return voxco.security.has('USE_TRANSLATION', data.Permissions); } },
                { "Action": "variables", "Label": resources.TranslateQuestions, "DisplayCondition": function (data) { return voxco.security.has('USE_TRANSLATION', data.Permissions); } },
                { "Action": "screens", "Label": resources.TranslateScreens, "DisplayCondition": function (data) { return voxco.security.has('USE_TRANSLATION', data.Permissions); } },
                { "Divider": true },
                { "Action": "changes", "Label": resources.QuestionnaireChanges, "DisplayCondition": function (data) { return voxco.security.has('USE_TRANSACTIONMANAGER', data.Permissions); } },
                { "Action": "associatedProjects", "Label": resources.AssociatedProjects }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "rename":
                        modalDialog.showWindow(a4.getAction("EditQuestionnaire", "Home", "Project", { questionnaireId: row.Id }), 220, 600, { afterClose: questionnaires.refreshContent });
                        break;
                    case "delete":
                        questionnaires.deleteQuestionnaires([row.Id]);
                        break;
                    case "update":
                        modalDialog.showWindow(a4.getAction("UpdateQuestionnaire", "Home", "Project", { questionnaireId: row.Id }), 220, 600, { afterClose: questionnaires.refreshContent });
                        break;
                    case "download":
                        window.location = a4.getAction("DownloadQuestionnaire", "Home", "Project", { questionnaireId: row.Id });
                        break;
                    case "includeFiles":
                        modalDialog.showWindow(a4.getAction("IncludeFiles", "Home", "Project", { questionnaireId: row.Id, questionnaireName: row.Name }), 600, 1000);
                        break;
                    case "lock":
                        a4.callServerMethod(a4.getAction("LockQuestionnaire", "Home", "Project"), { questionnaireId: row.Id }, function (result) {
                            questionnaires.refreshContent();
                        });
                        break;
                    case "unlock":
                        a4.callServerMethod(a4.getAction("UnlockQuestionnaire", "Home", "Project"), { questionnaireId: row.Id }, function (result) {
                            questionnaires.refreshContent();
                        });
                        break;
                    case "messages":
                        modalDialog.showWindow(a4.getAction("TranslateMessages", "Home", "Project", { questionnaireId: row.Id }), 600, 900);
                        break;
                    case "variables":
                        modalDialog.showWindow(a4.getAction("TranslateVariables", "Home", "Project", { questionnaireId: row.Id }), 600, 900);
                        break;
                    case "screens":
                        modalDialog.showWindow(a4.getAction("TranslateScreens", "Home", "Project", { questionnaireId: row.Id }), 600, 900);
                        break;
                    case "changes":
                        modalDialog.showWindow(a4.getAction("QuestionnaireChanges", "Home", "Project", { questionnaireId: row.Id, questionnaireName: row.Name }), 600, 1000);
                        break;
                    case "associatedProjects":
                        modalDialog.showWindow(a4.getAction("AssociatedProjects", "Home", "Project", { questionnaireId: row.Id, questionnaireName: row.Name }), 600, 1000);
                        break;
                    case "start":
                        questionnaires.startQuestionnaire(row.Id, row.Name);
                        break;
                    case "stop":
                        questionnaires.stopQuestionnaire(row.Id, row.Name);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                switch (action) {
                    case "delete":
                        questionnaires.deleteQuestionnaires(ids);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchQuestionnaires },
            draw: function (event, data) {
                $(".h-actionsMenu", questionnaires.context).toggle(data.totalRecords > 0);
            }
        });
    },
    initializeTreeView: function () {
        this.treeview = $(".h-questionnaireFolders", this.context).a4listview({
            ajaxAction: a4.getAction("GetQuestionnaireFolders", "Home", "Project"),
            stateKey: "Questionnaires",
            draw: function (event, data) {
                var folder = data.selectedNode;

                if (questionnaires.datatable) {
                    questionnaires.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": folder.Id });
                    questionnaires.datatable.a4datatable("refresh");
                }
                else {
                    questionnaires.initializeDataTable(folder);
                }
            },
            selectNode: function (event, data) {
                questionnaires.datatable.a4datatable("option", "ajaxParams", { "folderId": data.node.Id });
                questionnaires.datatable.a4datatable("refresh", true);

                questionnaires.selectNodeCallback(data.node);
            },
            actionButtons: [
                { Action: "delete", Label: resources.Delete, Icon: "remove", DisplayCondition: function (data) { return voxco.security.has('DELETE_GROUP', data.Permissions) && data.ParentId > 0; } },
                { Action: "properties", Label: resources.Properties, Icon: "edit", DisplayCondition: function (data) { return voxco.security.has('MODIFY_GROUP', data.Permissions) && data.ParentId > 0; } }
            ],
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "properties":
                        questionnaires.displayProperties(node.Id);
                        break;
                    case "delete":
                        questionnaires.deleteFolders(node.Id, node.Name);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchFolders }
        });
    },
    selectNodeCallback: function (folder) {
        if (folder) {
            var menu = $(".h-new-questionnaire-menu", questionnaires.context);

            var canCreateChild = voxco.security.has('CREATE', folder.Permissions);
            $(".h-new-questionnaire", menu).toggle(canCreateChild);

            var canCreateFolder = voxco.security.has('CREATE_GROUP', folder.Permissions);
            $(".h-new-questionnaire-folder", menu).toggle(canCreateFolder);

            menu.toggle(canCreateChild || canCreateFolder);
        }
    },
    bindEvents: function () {
        $(".h-new-questionnaire-menu").on("click", "li.h-new-questionnaire-folder", function () {
            var selectedFolder = $(".h-questionnaireFolders").a4listview("getHighlightedNode");

            var selectedFolderId = selectedFolder ? selectedFolder.Id : 0;

            modalDialog.showWindow(a4.getProjectAction("EditQuestionnaireFolder", "Home", { parentId: selectedFolderId }), 220, 600, { afterClose: questionnaires.refreshContent });
        });

        $(".h-new-questionnaire-menu").on("click", "li.h-new-questionnaire", function () {
            var selectedFolder = $(".h-questionnaireFolders").a4listview("getHighlightedNode");

            var selectedFolderId = selectedFolder ? selectedFolder.Id : 0;

            modalDialog.showWindow(a4.getProjectAction("EditQuestionnaire", "Home", { folderId: selectedFolderId }), 220, 600, { afterClose: questionnaires.refreshContent });
        });
    },
    refreshContent: function () {
        a4.hideBusyBox();
        questionnaires.treeview.a4listview("refresh");
    },
    startFolder: function (folderId, folderName) {
        modalDialog.showConfirmDialog(confirmActivateFolderResources, function () {
            a4.callServerMethod(a4.getAction("StartQuestionnaireFolder", "Home", "Project"), { folderId: folderId }, function (result) {
                questionnaires.treeview.a4listview("refresh");
            });
        }, null, null, false, { "folder": folderName });
    },
    stopFolder: function (folderId, folderName) {
        modalDialog.showConfirmDialog(confirmStopFolderResources, function () {
            a4.callServerMethod(a4.getAction("StopQuestionnaireFolder", "Home", "Project"), { folderId: folderId }, function (result) {
                questionnaires.treeview.a4listview("refresh");
            });
        }, null, null, false, { "folder": folderName });
    },
    startQuestionnaire: function (questionnaireId, questionnaireName) {
        modalDialog.showConfirmDialog(confirmActivateQuestionnaireResources, function () {
            a4.callServerMethod(a4.getAction("StartQuestionnaire", "Home", "Project"), { questionnaireId: questionnaireId }, function (result) {
                questionnaires.datatable.a4datatable("refresh");
            });
        }, null, null, false, { "questionnaire": questionnaireName });
    },
    stopQuestionnaire: function (questionnaireId, questionnaireName) {
        modalDialog.showConfirmDialog(confirmStopQuestionnaireResources, function () {
            a4.callServerMethod(a4.getAction("StopQuestionnaire", "Home", "Project"), { questionnaireId: questionnaireId }, function (result) {
                questionnaires.datatable.a4datatable("refresh");
            });
        }, null, null, false, { "questionnaire": questionnaireName });
    },
    deleteQuestionnaires: function (questionnaireIds) {
        modalDialog.showConfirmDelete(confirmDeleteQuestionnaires, function () {
            a4.callServerMethod(a4.getAction("DeleteQuestionnaires", "Home", "Project"), { questionnaireIds: questionnaireIds }, function (result) {
                    questionnaires.refreshContent();
                });
        }, questionnaireIds.length);
    },
    deleteFolders: function (selectedFolderId, folderName) {
        modalDialog.showConfirmDialog(
            deleteFoldersResources,
            function () {
                a4.callServerMethod(a4.getAction("DeleteQuestionnaireFolder", "Home", "Project"), { id: selectedFolderId },
                    function (result) {
                        if (result.success) {
                            questionnaires.refreshContent();
                        }
                        else {
                            a4.showErrorMessage(result.message);
                        }
                    }
                );
            },
            null, null, false,
            { "folder": folderName }
        );
    },
    displayProperties: function (selectedFolderId , parentId) {
        modalDialog.showWindow(a4.getProjectAction("EditQuestionnaireFolder", "Home", { id: selectedFolderId, parentId: parentId }), 220, 600, { afterClose: questionnaires.refreshContent });
    }
}

$(document).ready(function () {
    if (questionnaires.context.length > 0) {
        questionnaires.initializeTreeView();
        questionnaires.bindEvents();
    }
});

/// Function to verify if name already present in Questionnaire folders
/// Criteria is the same a folders with the same name already exists under the same parent.
function questionnaireFoldersContainsNode(parentId, selectedFolderId, newName) {
    var result = false;
    var nodes = questionnaires.treeview.a4listview("getNodes");

    $.each(nodes, function (index, value) {
        if (value.ParentId == parentId && value.Id != selectedFolderId && value.Name.toUpperCase() == newName.toUpperCase()) {
            result = true;
            return false; // this is equivalent to a break from the foreach loop
        }
    });

    return result;
}